unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Mask, Buttons;

type
  TFOsoby = class(TForm)
    GroupBox1: TGroupBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    meNazwisko: TMaskEdit;
    meImie: TMaskEdit;
    meMcowosc: TMaskEdit;
    meUlicaInr: TMaskEdit;
    meKodp: TMaskEdit;
    meMiasto: TMaskEdit;
    mePesel: TMaskEdit;
    dtpDataUr: TDateTimePicker;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure dodaj_rekord();

    // ustawiam kontrolki ekranowe
    procedure set_nazwisko();
    procedure set_imie();
    procedure set_dataur();
    procedure set_mcowosc();
    procedure set_ulicainr();
    procedure set_kodp();
    procedure set_miasto();
    procedure set_pesel();

    // pobieram wartoci z kontrolki ekranowe
    function get_nazwisko(): String;
    function get_imie(): String;
    function get_dataur(): TDateTime;
    function get_mcowosc(): String;
    function get_ulicainr(): String;
    function get_kodp(): String;
    function get_miasto(): String;
    function get_pesel(): String;
  end;

var
  FOsoby: TFOsoby;

implementation
{$R *.dfm}
Uses
   DataModule;


procedure TFOsoby.FormCreate(Sender: TObject);
begin
   set_nazwisko();
   set_imie();
   set_dataur();
   set_mcowosc();
   set_ulicainr();
   set_kodp();
   set_miasto();
   set_pesel();
end;

procedure TFOsoby.set_nazwisko();
begin
   meNazwisko.Text := '';
end;

procedure TFOsoby.set_imie();
begin
   meImie.Text := '';
end;

procedure TFOsoby.set_dataur();
begin
   dtpDataur.Date := Now();
end;

procedure TFOsoby.set_mcowosc();
begin
   meMcowosc.Text := '';
end;

procedure TFOsoby.set_ulicainr();
begin
   meUlicaInr.Text := '';
end;

procedure TFOsoby.set_kodp();
begin
   meKodp.Text := '';
end;

procedure TFOsoby.set_miasto();
begin
   meMiasto.Text := '';
end;

procedure TFOsoby.set_pesel();
begin
   mePesel.Text := '';
end;

procedure TFOsoby.BitBtn1Click(Sender: TObject);
begin
   // wstawi rekord mozna tylko wtedy
   // gdy conajmniej
   // pola nazwisko i imi maj jakie wartoci

   if (meNazwisko.Text <> '') and (meImie.Text <> '') then begin
      dodaj_rekord();
   end;
end;

procedure TFOsoby.Dodaj_rekord();
begin
   with DM.ADOCommand.Parameters do begin
//      ParamByName('IDOSOBY').Value  := 7;   // get_idosoby();
      ParamByName('NAZWISKO').Value := get_nazwisko();
      ParamByName('IMIE').Value     := get_imie();
      ParamByName('DATAUR').Value   := get_dataur();
      ParamByName('MCOWOSC').Value  := get_mcowosc();
      ParamByName('ULICAINR').Value := get_ulicainr();
      ParamByName('KODP').Value     := get_kodp();
      ParamByName('MIASTO').Value   := get_miasto();
      ParamByName('PESEL').Value    := get_pesel();
   end;

   DM.ADOCommand.Execute();
end;

function TFOsoby.get_nazwisko(): String;
begin
   result := meNazwisko.Text;
end;

function TFOsoby.get_imie(): String;
begin
   result := meImie.Text;
end;
function TFOsoby.get_dataur(): TDateTime;
begin
   result := dtpDataUr.Date;
end;

function TFOsoby.get_mcowosc(): String;
begin
   result := meMcowosc.Text;
end;

function TFOsoby.get_ulicainr(): String;
begin
   result := meUlicaINr.Text;
end;

function TFOsoby.get_kodp(): String;
begin
   result := meKodp.Text;
end;

function TFOsoby.get_miasto(): String;
begin
   result := meMiasto.Text;
end;

function TFOsoby.get_pesel(): String;
begin
   result := mePesel.Text;
end;

end.

